<?php
/**
 * Plugin Name: Srizon AI Image
 * Plugin URI: https://www.srizon.com/srizon-ai-image
 * Description: Generate AI images using Google Gemini directly in WordPress editor and media library.
 * Version: 1.0.1
 * Author: Srizon
 * Author URI: https://www.srizon.com
 * License: GPL-2.0+
 * License URI: http://www.gnu.org/licenses/gpl-2.0.txt
 * Text Domain: srizon-ai-image
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 *
 * @package Srizon_AI_Image
 */

// If this file is called directly, abort.
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

/**
 * Plugin version.
 */
define( 'SRIZON_AI_IMAGE_VERSION', '1.0.0' );

/**
 * Plugin base path.
 */
define( 'SRIZON_AI_IMAGE_PATH', plugin_dir_path( __FILE__ ) );

/**
 * Plugin base URL.
 */
define( 'SRIZON_AI_IMAGE_URL', plugin_dir_url( __FILE__ ) );

/**
 * Code that runs during plugin activation.
 */
function activate_srizon_ai_image() {
    require_once SRIZON_AI_IMAGE_PATH . 'includes/class-srizon-ai-image-activator.php';
    Srizon_AI_Image_Activator::activate();
}

/**
 * Code that runs during plugin deactivation.
 */
function deactivate_srizon_ai_image() {
    require_once SRIZON_AI_IMAGE_PATH . 'includes/class-srizon-ai-image-deactivator.php';
    Srizon_AI_Image_Deactivator::deactivate();
}

register_activation_hook( __FILE__, 'activate_srizon_ai_image' );
register_deactivation_hook( __FILE__, 'deactivate_srizon_ai_image' );

/**
 * The core plugin class.
 */
require SRIZON_AI_IMAGE_PATH . 'includes/class-srizon-ai-image.php';

/**
 * Begins execution of the plugin.
 */
function run_srizon_ai_image() {
    $plugin = new Srizon_AI_Image();
    $plugin->run();
}

run_srizon_ai_image();
